from paraview.simple import *

maxSize = 2
stlXmin = -.000645716
stlXmax = .997966
stlYmin = -1
stlYmax = 1
stlZmin = -.0451203
stlZmax = .0759681
XfocalPoint = (stlXmax + stlXmin) / 2
YfocalPoint = (stlYmax + stlYmin) / 2
ZfocalPoint = (stlZmax + stlZmin) / 2
camDist1 = 2.2 * maxSize
camDist2 = 1.1 * maxSize
spheresize = .1997223432

aircraftstl = STLReader(FileNames=['./geometry-input/aircraft.stl'])
renderView1 = GetActiveViewOrCreate('RenderView')
renderView1.ViewSize = [800, 600]
renderView1.UseColorPaletteForBackground = 0
renderView1.Background = [1.0, 1.0, 1.0]
aircraftstlDisplay = Show(aircraftstl, renderView1)

sTLSolidLabelingLUT = GetColorTransferFunction('STLSolidLabeling')
sTLSolidLabelingLUT.RGBPoints = [0.0, 0.231373, 0.298039, 0.752941, 5.878906683738906e-39, 0.865003, 0.865003, 0.865003, 1.1757813367477812e-38, 0.705882, 0.0156863, 0.14902]
sTLSolidLabelingLUT.ScalarRangeInitialized = 1.0

aircraftstlDisplay.Representation = 'Surface'
aircraftstlDisplay.ColorArrayName = ['CELLS', 'STLSolidLabeling']
aircraftstlDisplay.LookupTable = sTLSolidLabelingLUT
aircraftstlDisplay.OSPRayScaleFunction = 'PiecewiseFunction'
aircraftstlDisplay.SelectOrientationVectors = 'None'
aircraftstlDisplay.ScaleFactor = 0.8
aircraftstlDisplay.SelectScaleArray = 'STLSolidLabeling'
aircraftstlDisplay.GlyphType = 'Arrow'
aircraftstlDisplay.GlyphTableIndexArray = 'STLSolidLabeling'
aircraftstlDisplay.GaussianRadius = 0.04
aircraftstlDisplay.SetScaleArray = [None, '']
aircraftstlDisplay.ScaleTransferFunction = 'PiecewiseFunction'
aircraftstlDisplay.OpacityArray = [None, '']
aircraftstlDisplay.OpacityTransferFunction = 'PiecewiseFunction'
aircraftstlDisplay.DataAxesGrid = 'GridAxesRepresentation'
aircraftstlDisplay.SelectionCellLabelFontFile = ''
aircraftstlDisplay.SelectionPointLabelFontFile = ''
aircraftstlDisplay.PolarAxes = 'PolarAxesRepresentation'
aircraftstlDisplay.DataAxesGrid.XTitleFontFile = ''
aircraftstlDisplay.DataAxesGrid.YTitleFontFile = ''
aircraftstlDisplay.DataAxesGrid.ZTitleFontFile = ''
aircraftstlDisplay.DataAxesGrid.XLabelFontFile = ''
aircraftstlDisplay.DataAxesGrid.YLabelFontFile = ''
aircraftstlDisplay.DataAxesGrid.ZLabelFontFile = ''
aircraftstlDisplay.PolarAxes.PolarAxisTitleFontFile = ''
aircraftstlDisplay.PolarAxes.PolarAxisLabelFontFile = ''
aircraftstlDisplay.PolarAxes.LastRadialAxisTextFontFile = ''
aircraftstlDisplay.PolarAxes.SecondaryRadialAxesTextFontFile = ''
renderView1.ResetCamera()
materialLibrary1 = GetMaterialLibrary()
aircraftstlDisplay.SetScalarBarVisibility(renderView1, True)
renderView1.Update()


sTLSolidLabelingPWF = GetOpacityTransferFunction('STLSolidLabeling')
sTLSolidLabelingPWF.Points = [0.0, 0.0, 0.5, 0.0, 1.1757813367477812e-38, 1.0, 0.5, 0.0]
sTLSolidLabelingPWF.ScalarRangeInitialized = 1


aircraftstlDisplay.SetScalarBarVisibility(renderView1, False)
ColorBy(aircraftstlDisplay, None)
HideScalarBarIfNotNeeded(sTLSolidLabelingLUT, renderView1)
renderView1.ResetCamera()

renderView1.CameraFocalPoint = [XfocalPoint, YfocalPoint, ZfocalPoint]
renderView1.CameraParallelScale = 1.0

#exporting views
renderView1.CameraPosition = [XfocalPoint, YfocalPoint, camDist1]
renderView1.CameraViewUp = [0, 1, 0]
SaveScreenshot('./IMG/STLviewZpos.jpg', renderView1, ImageResolution=[1920, 1080], Quality=90)
renderView1.CameraPosition = [XfocalPoint, YfocalPoint, -camDist1]
renderView1.CameraViewUp = [0, 1, 0]
SaveScreenshot('./IMG/STLviewZneg.jpg', renderView1, ImageResolution=[1920, 1080], Quality=90)
renderView1.CameraPosition = [XfocalPoint, camDist1, ZfocalPoint]
renderView1.CameraViewUp = [0, 0, 1]
SaveScreenshot('./IMG/STLviewYpos.jpg', renderView1, ImageResolution=[1920, 1080], Quality=90)
renderView1.CameraPosition = [XfocalPoint, -camDist1, ZfocalPoint]
renderView1.CameraViewUp = [0, 0, 1]
SaveScreenshot('./IMG/STLviewYneg.jpg', renderView1, ImageResolution=[1920, 1080], Quality=90)
renderView1.CameraPosition = [camDist1, YfocalPoint, ZfocalPoint]
renderView1.CameraViewUp = [0, 0, 1]
SaveScreenshot('./IMG/STLviewXpos.jpg', renderView1, ImageResolution=[1920, 1080], Quality=90)
renderView1.CameraPosition = [-camDist1, YfocalPoint, ZfocalPoint]
renderView1.CameraViewUp = [0, 0, 1]
SaveScreenshot('./IMG/STLviewXneg.jpg', renderView1, ImageResolution=[1920, 1080], Quality=90)
renderView1.CameraPosition = [-camDist2, camDist2, -camDist2]
renderView1.CameraViewUp = [0, 0, 1]
SaveScreenshot('./IMG/STLviewTQ1.jpg', renderView1, ImageResolution=[1920, 1080], Quality=90)
renderView1.CameraPosition = [-camDist2, camDist2, camDist2]
renderView1.CameraViewUp = [0, 0, 1]
SaveScreenshot('./IMG/STLviewTQ2.jpg', renderView1, ImageResolution=[1920, 1080], Quality=90)
renderView1.CameraPosition = [camDist2, camDist2, camDist2]
renderView1.CameraViewUp = [0, 0, 1]
SaveScreenshot('./IMG/STLviewTQ3.jpg', renderView1, ImageResolution=[1920, 1080], Quality=90)
renderView1.CameraPosition = [camDist2, camDist2, -camDist2]
renderView1.CameraViewUp = [0, 0, 1]
SaveScreenshot('./IMG/STLviewTQ4.jpg', renderView1, ImageResolution=[1920, 1080], Quality=90)


aircraftstlDisplay.Opacity = 0.16
featureEdges1 = FeatureEdges(Input=aircraftstl)
featureEdges1.FeatureEdges = 0
featureEdges1.NonManifoldEdges = 0
featureEdges1Display = Show(featureEdges1, renderView1)
featureEdges1Display.Representation = 'Surface'
featureEdges1Display.ColorArrayName = [None, '']
featureEdges1Display.OSPRayScaleFunction = 'PiecewiseFunction'
featureEdges1Display.SelectOrientationVectors = 'None'
featureEdges1Display.ScaleFactor = 1
featureEdges1Display.SelectScaleArray = 'None'
featureEdges1Display.GlyphType = 'Arrow'
featureEdges1Display.GlyphTableIndexArray = 'None'
featureEdges1Display.GaussianRadius = 0.04
featureEdges1Display.SetScaleArray = [None, '']
featureEdges1Display.ScaleTransferFunction = 'PiecewiseFunction'
featureEdges1Display.OpacityArray = [None, '']
featureEdges1Display.OpacityTransferFunction = 'PiecewiseFunction'
featureEdges1Display.DataAxesGrid = 'GridAxesRepresentation'
featureEdges1Display.SelectionCellLabelFontFile = ''
featureEdges1Display.SelectionPointLabelFontFile = ''
featureEdges1Display.PolarAxes = 'PolarAxesRepresentation'
featureEdges1Display.DataAxesGrid.XTitleFontFile = ''
featureEdges1Display.DataAxesGrid.YTitleFontFile = ''
featureEdges1Display.DataAxesGrid.ZTitleFontFile = ''
featureEdges1Display.DataAxesGrid.XLabelFontFile = ''
featureEdges1Display.DataAxesGrid.YLabelFontFile = ''
featureEdges1Display.DataAxesGrid.ZLabelFontFile = ''
featureEdges1Display.PolarAxes.PolarAxisTitleFontFile = ''
featureEdges1Display.PolarAxes.PolarAxisLabelFontFile = ''
featureEdges1Display.PolarAxes.LastRadialAxisTextFontFile = ''
featureEdges1Display.PolarAxes.SecondaryRadialAxesTextFontFile = ''
renderView1.Update()
featureEdges1Display.DiffuseColor = [1.0, 0.0, 0.0]
featureEdges1Display.LineWidth = 3.0

#exporting views for hole detection
renderView1.CameraPosition = [XfocalPoint, YfocalPoint, camDist1]
renderView1.CameraViewUp = [0, 1, 0]
SaveScreenshot('./IMG/STLholeDetectionZpos.jpg', renderView1, ImageResolution=[1920, 1080], Quality=90)
renderView1.CameraPosition = [XfocalPoint, camDist1, ZfocalPoint]
renderView1.CameraViewUp = [0, 0, 1]
SaveScreenshot('./IMG/STLholeDetectionYpos.jpg', renderView1, ImageResolution=[1920, 1080], Quality=90)
renderView1.CameraPosition = [camDist1, YfocalPoint, ZfocalPoint]
renderView1.CameraViewUp = [0, 0, 1]
SaveScreenshot('./IMG/STLholeDetectionXpos.jpg', renderView1, ImageResolution=[1920, 1080], Quality=90)

#exporting a view for direction check
Delete(featureEdges1)
aircraftstlDisplay.Opacity = 0.3
renderView1.CameraPosition = [-1.2*camDist2, 1.2*camDist2, 1.2*camDist2]
renderView1.CameraViewUp = [0, 0, 1]
axes1 = Axes()
axes1Display = Show(axes1, renderView1)
axesLUT = GetColorTransferFunction('Axes')
axes1Display.Representation = 'Surface'
axes1Display.ColorArrayName = ['POINTS', 'Axes']
axes1Display.LookupTable = axesLUT
axes1Display.OSPRayScaleArray = 'Axes'
axes1Display.OSPRayScaleFunction = 'PiecewiseFunction'
axes1Display.SelectOrientationVectors = 'Axes'
axes1Display.ScaleFactor = 0.1
axes1Display.SelectScaleArray = 'Axes'
axes1Display.GlyphType = 'Arrow'
axes1Display.GlyphTableIndexArray = 'Axes'
axes1Display.GaussianRadius = 0.005
axes1Display.SetScaleArray = ['POINTS', 'Axes']
axes1Display.ScaleTransferFunction = 'PiecewiseFunction'
axes1Display.OpacityArray = ['POINTS', 'Axes']
axes1Display.OpacityTransferFunction = 'PiecewiseFunction'
axes1Display.DataAxesGrid = 'GridAxesRepresentation'
axes1Display.SelectionCellLabelFontFile = ''
axes1Display.SelectionPointLabelFontFile = ''
axes1Display.PolarAxes = 'PolarAxesRepresentation'
axes1Display.DataAxesGrid.XTitleFontFile = ''
axes1Display.DataAxesGrid.YTitleFontFile = ''
axes1Display.DataAxesGrid.ZTitleFontFile = ''
axes1Display.DataAxesGrid.XLabelFontFile = ''
axes1Display.DataAxesGrid.YLabelFontFile = ''
axes1Display.DataAxesGrid.ZLabelFontFile = ''
axes1Display.PolarAxes.PolarAxisTitleFontFile = ''
axes1Display.PolarAxes.PolarAxisLabelFontFile = ''
axes1Display.PolarAxes.LastRadialAxisTextFontFile = ''
axes1Display.PolarAxes.SecondaryRadialAxesTextFontFile = ''
renderView1.Update()
axesPWF = GetOpacityTransferFunction('Axes')
ColorBy(axes1Display, ('POINTS', 'Axes'))
axes1Display.RescaleTransferFunctionToDataRange(True, False)
axes1Display.PointSize = 20.0
axes1Display.LineWidth = 10.0
axes1Display.RenderLinesAsTubes = 1
axes1.ScaleFactor = maxSize * 0.75
axes1Display.SetScalarBarVisibility(renderView1, False)
axesLUT.ApplyPreset('jet', True)

text1 = Text()
text1.Text = 'Rear'
text1Display = Show(text1, renderView1)
text1Display.FontFile = ''
renderView1.Update()
text1Display.WindowLocation = 'Any Location'
text1Display.Position = [0.22, 0.6]
text2 = Text()
text2.Text = 'Right'
text2Display = Show(text2, renderView1)
text2Display.FontFile = ''
renderView1.Update()
text2Display.WindowLocation = 'Any Location'
text2Display.Position = [0.25, 0.05]
text3 = Text()
text3.Text = 'Up'
text3Display = Show(text3, renderView1)
text3Display.FontFile = ''
renderView1.Update()
text3Display.WindowLocation = 'Any Location'
text3Display.Position = [0.47, 0.9]
text4 = Text()
text4.Text = 'CoG'
text4Display = Show(text4, renderView1)
text4Display.FontFile = ''
renderView1.Update()
text4Display.WindowLocation = 'Any Location'
text4Display.Position = [0.7, 0.4]

text4Display.Color = [1.0, 0.0, 1.0]
text3Display.Color = [0.6666666666666666, 0.0, 0.0]
text2Display.Color = [0.0, 0.6666666666666666, 0.0]
text1Display.Color = [0.0, 0.0, 1.0]

aircraftstlDisplay.Opacity = 0.3

sphere1 = Sphere()
sphere1.Radius = spheresize
sphere1.ThetaResolution = 16

sphere1Display = Show(sphere1, renderView1)
sphere1Display.Representation = 'Surface'
sphere1Display.ColorArrayName = [None, '']
sphere1Display.OSPRayScaleArray = 'Normals'
sphere1Display.OSPRayScaleFunction = 'PiecewiseFunction'
sphere1Display.SelectOrientationVectors = 'None'
sphere1Display.ScaleFactor = 0.010292799770832063
sphere1Display.SelectScaleArray = 'None'
sphere1Display.GlyphType = 'Arrow'
sphere1Display.GlyphTableIndexArray = 'None'
sphere1Display.GaussianRadius = 0.0005146399885416031
sphere1Display.SetScaleArray = ['POINTS', 'Normals']
sphere1Display.ScaleTransferFunction = 'PiecewiseFunction'
sphere1Display.OpacityArray = ['POINTS', 'Normals']
sphere1Display.OpacityTransferFunction = 'PiecewiseFunction'
sphere1Display.DataAxesGrid = 'GridAxesRepresentation'
sphere1Display.PolarAxes = 'PolarAxesRepresentation'
sphere1Display.ScaleTransferFunction.Points = [-0.9749279022216797, 0.0, 0.5, 0.0, 0.9749279022216797, 1.0, 0.5, 0.0]
sphere1Display.OpacityTransferFunction.Points = [-0.9749279022216797, 0.0, 0.5, 0.0, 0.9749279022216797, 1.0, 0.5, 0.0]
sphere1Display.AmbientColor = [1.0, 0.0, 1.0]
sphere1Display.DiffuseColor = [1.0, 0.0, 1.0]

SaveScreenshot('./IMG/STLviewOrientation.jpg', renderView1, ImageResolution=[1920, 1080], Quality=90)



