from paraview.simple import *

maxSize = 1.0
stlXmin = -.000645716
stlXmax = 1.07286
stlYmin = 0
stlYmax = 1
stlZmin = -.164753
stlZmax = .0759681
XfocalPoint = (stlXmax + stlXmin) / 2
YfocalPoint = (stlYmax + stlYmin) / 2
ZfocalPoint = (stlZmax + stlZmin) / 2
camDist1 = 2.2 * maxSize
camDist2 = 1.1 * maxSize
CamParalScale = 0.35 * (stlXmax - stlXmin)
CamParalScale2 = 1.4 * (stlXmax - stlXmin)
CamParalScale3 = 4.8 * (stlXmax - stlXmin)

paraview.simple._DisableFirstRenderCameraReset()
casefoam = OpenFOAMReader(FileName='./case.foam')
casefoam.MeshRegions = ['patch/domainSymmetry-int']
casefoam.SkipZeroTime = 0
casefoam.CaseType = 'Decomposed Case'
renderView1 = GetActiveViewOrCreate('RenderView')
renderView1.ViewSize = [800, 600]
renderView1.UseColorPaletteForBackground = 0
renderView1.Background = [1.0, 1.0, 1.0]

casefoamDisplay = Show(casefoam, renderView1)
casefoamDisplay.Representation = 'Surface'
casefoamDisplay.ColorArrayName = [None, '']
casefoamDisplay.OSPRayScaleArray = 'thickness'
casefoamDisplay.OSPRayScaleFunction = 'PiecewiseFunction'
casefoamDisplay.SelectOrientationVectors = 'None'
casefoamDisplay.ScaleFactor = 3.0000437736511234
casefoamDisplay.SelectScaleArray = 'None'
casefoamDisplay.GlyphType = 'Arrow'
casefoamDisplay.GlyphTableIndexArray = 'None'
casefoamDisplay.GaussianRadius = 0.15000218868255616
casefoamDisplay.SetScaleArray = ['CELLS', 'thickness']
casefoamDisplay.ScaleTransferFunction = 'PiecewiseFunction'
casefoamDisplay.OpacityArray = ['CELLS', 'thickness']
casefoamDisplay.OpacityTransferFunction = 'PiecewiseFunction'
casefoamDisplay.DataAxesGrid = 'GridAxesRepresentation'
casefoamDisplay.SelectionCellLabelFontFile = ''
casefoamDisplay.SelectionPointLabelFontFile = ''
casefoamDisplay.PolarAxes = 'PolarAxesRepresentation'
casefoamDisplay.DataAxesGrid.XTitleFontFile = ''
casefoamDisplay.DataAxesGrid.YTitleFontFile = ''
casefoamDisplay.DataAxesGrid.ZTitleFontFile = ''
casefoamDisplay.DataAxesGrid.XLabelFontFile = ''
casefoamDisplay.DataAxesGrid.YLabelFontFile = ''
casefoamDisplay.DataAxesGrid.ZLabelFontFile = ''
casefoamDisplay.PolarAxes.PolarAxisTitleFontFile = ''
casefoamDisplay.PolarAxes.PolarAxisLabelFontFile = ''
casefoamDisplay.PolarAxes.LastRadialAxisTextFontFile = ''
casefoamDisplay.PolarAxes.SecondaryRadialAxesTextFontFile = ''


renderView1.ResetCamera()
renderView1.InteractionMode = '2D'
renderView1.CameraPosition = [XfocalPoint, camDist1, ZfocalPoint]
renderView1.CameraFocalPoint = [XfocalPoint, YfocalPoint, ZfocalPoint]
renderView1.CameraViewUp = [0.0, 0.0, 1.0]
materialLibrary1 = GetMaterialLibrary()
renderView1.Update()
renderView1.ResetCamera()
renderView1.CameraParallelScale = CamParalScale
renderView1.CameraParallelProjection = 1

renderView1.Update()
renderView1.ResetCamera()


# turn off scalar coloring
ColorBy(casefoamDisplay, None)
casefoamDisplay.SetRepresentationType('Wireframe')
casefoamDisplay.AmbientColor = [0.0, 0.0, 0.0]
casefoamDisplay.DiffuseColor = [0.0, 0.0, 0.0]

# current camera placement for renderView1
renderView1.InteractionMode = '2D'
renderView1.CameraParallelProjection = 1
renderView1.CameraPosition = [XfocalPoint, camDist1, ZfocalPoint]
renderView1.CameraFocalPoint = [XfocalPoint, YfocalPoint, ZfocalPoint]
renderView1.CameraViewUp = [0.0, 0.0, 1.0]
renderView1.CameraParallelScale = CamParalScale

# saving the first screenshot twice, otherwise camera will be wrong for some reason
SaveScreenshot('./IMG/Meshview_mesh-A.jpg', renderView1, ImageResolution=[192, 108], Quality=90)
renderView1.CameraPosition = [XfocalPoint, camDist1, ZfocalPoint]
renderView1.CameraFocalPoint = [XfocalPoint, YfocalPoint, ZfocalPoint]
renderView1.CameraViewUp = [0.0, 0.0, 1.0]
renderView1.CameraParallelScale = CamParalScale
SaveScreenshot('./IMG/Meshview_mesh-A.jpg', renderView1, ImageResolution=[1920, 1080], Quality=90)
renderView1.CameraParallelScale = CamParalScale2
SaveScreenshot('./IMG/Meshview_mesh-B.jpg', renderView1, ImageResolution=[1920, 1080], Quality=90)
renderView1.CameraParallelScale = CamParalScale3
SaveScreenshot('./IMG/Meshview_mesh-C.jpg', renderView1, ImageResolution=[1920, 1080], Quality=90)

