import os, os.path
from paraview.simple import *
paraview.simple._DisableFirstRenderCameraReset()


currentDir='./'
maxSize = 1.0
stlXmin = -.000645716
stlXmax = 1.07286
stlYmin = 0
stlYmax = 1
stlZmin = -.164753
stlZmax = .0759681
XfocalPoint = (stlXmax + stlXmin) / 2
YfocalPoint = (stlYmax + stlYmin) / 2
ZfocalPoint = (stlZmax + stlZmin) / 2
camDist1 = 2.2 * maxSize
camDist2 = 1.1 * maxSize
CamParalScale = 1.05 * (stlXmax - stlXmin)

poor=False
bad=False
awful=False
maxU=False
dirmeshedAircraft=os.path.join(currentDir,'postProcessing/constant/meshedAircraftSurface.obj')
dirhighAspectRatioCells=os.path.join(currentDir,'postProcessing/constant/highAspectRatioCells/highAspectRatioCells.vtk')
dirnonOrthoFaces=os.path.join(currentDir,'postProcessing/constant/nonOrthoFaces/nonOrthoFaces.vtk')
dirskewFaces=os.path.join(currentDir,'postProcessing/constant/skewFaces/skewFaces.vtk')
dirwrongOrientedFaces=os.path.join(currentDir,'postProcessing/constant/wrongOrientedFaces/wrongOrientedFaces.vtk')
dirzeroVolumeCells=os.path.join(currentDir,'postProcessing/constant/zeroVolumeCells/zeroVolumeCells.vtk')
dirmaxU=os.path.join(currentDir,'postProcessing/constant/maxU')

meshedAircraftSurfaceobj = WavefrontOBJReader(FileName=dirmeshedAircraft)
renderView1 = GetActiveViewOrCreate('RenderView')
renderView1.ViewSize = [800, 600]
renderView1.UseColorPaletteForBackground = 0
renderView1.Background = [1.0, 1.0, 1.0]
meshedAircraftSurfaceobjDisplay = Show(meshedAircraftSurfaceobj, renderView1)
meshedAircraftSurfaceobjDisplay.Representation = 'Surface'
meshedAircraftSurfaceobjDisplay.ColorArrayName = [None, '']
meshedAircraftSurfaceobjDisplay.OSPRayScaleFunction = 'PiecewiseFunction'
meshedAircraftSurfaceobjDisplay.SelectOrientationVectors = 'None'
meshedAircraftSurfaceobjDisplay.ScaleFactor = 0.603541100025177
meshedAircraftSurfaceobjDisplay.SelectScaleArray = 'None'
meshedAircraftSurfaceobjDisplay.GlyphType = 'Arrow'
meshedAircraftSurfaceobjDisplay.GlyphTableIndexArray = 'None'
meshedAircraftSurfaceobjDisplay.GaussianRadius = 0.030177055001258852
meshedAircraftSurfaceobjDisplay.SetScaleArray = [None, '']
meshedAircraftSurfaceobjDisplay.ScaleTransferFunction = 'PiecewiseFunction'
meshedAircraftSurfaceobjDisplay.OpacityArray = [None, '']
meshedAircraftSurfaceobjDisplay.OpacityTransferFunction = 'PiecewiseFunction'
meshedAircraftSurfaceobjDisplay.DataAxesGrid = 'GridAxesRepresentation'
meshedAircraftSurfaceobjDisplay.SelectionCellLabelFontFile = ''
meshedAircraftSurfaceobjDisplay.SelectionPointLabelFontFile = ''
meshedAircraftSurfaceobjDisplay.PolarAxes = 'PolarAxesRepresentation'
meshedAircraftSurfaceobjDisplay.DataAxesGrid.XTitleFontFile = ''
meshedAircraftSurfaceobjDisplay.DataAxesGrid.YTitleFontFile = ''
meshedAircraftSurfaceobjDisplay.DataAxesGrid.ZTitleFontFile = ''
meshedAircraftSurfaceobjDisplay.DataAxesGrid.XLabelFontFile = ''
meshedAircraftSurfaceobjDisplay.DataAxesGrid.YLabelFontFile = ''
meshedAircraftSurfaceobjDisplay.DataAxesGrid.ZLabelFontFile = ''
meshedAircraftSurfaceobjDisplay.PolarAxes.PolarAxisTitleFontFile = ''
meshedAircraftSurfaceobjDisplay.PolarAxes.PolarAxisLabelFontFile = ''
meshedAircraftSurfaceobjDisplay.PolarAxes.LastRadialAxisTextFontFile = ''
meshedAircraftSurfaceobjDisplay.PolarAxes.SecondaryRadialAxesTextFontFile = ''
renderView1.ResetCamera()
materialLibrary1 = GetMaterialLibrary()
renderView1.Update()



if os.path.exists(dirhighAspectRatioCells):
	bad=True
	highAspectRatioCellsvtk = LegacyVTKReader(FileNames=[dirhighAspectRatioCells])
	highAspectRatioCellsvtkDisplay = Show(highAspectRatioCellsvtk, renderView1)
	highAspectRatioCellsvtkDisplay.Representation = 'Surface'
	highAspectRatioCellsvtkDisplay.ColorArrayName = [None, '']
	highAspectRatioCellsvtkDisplay.OSPRayScaleFunction = 'PiecewiseFunction'
	highAspectRatioCellsvtkDisplay.SelectOrientationVectors = 'None'
	highAspectRatioCellsvtkDisplay.ScaleFactor = 0.008330923318862916
	highAspectRatioCellsvtkDisplay.SelectScaleArray = 'None'
	highAspectRatioCellsvtkDisplay.GlyphType = 'Arrow'
	highAspectRatioCellsvtkDisplay.GlyphTableIndexArray = 'None'
	highAspectRatioCellsvtkDisplay.GaussianRadius = 0.0004165461659431458
	highAspectRatioCellsvtkDisplay.SetScaleArray = [None, '']
	highAspectRatioCellsvtkDisplay.ScaleTransferFunction = 'PiecewiseFunction'
	highAspectRatioCellsvtkDisplay.OpacityArray = [None, '']
	highAspectRatioCellsvtkDisplay.OpacityTransferFunction = 'PiecewiseFunction'
	highAspectRatioCellsvtkDisplay.DataAxesGrid = 'GridAxesRepresentation'
	highAspectRatioCellsvtkDisplay.SelectionCellLabelFontFile = ''
	highAspectRatioCellsvtkDisplay.SelectionPointLabelFontFile = ''
	highAspectRatioCellsvtkDisplay.PolarAxes = 'PolarAxesRepresentation'
	highAspectRatioCellsvtkDisplay.DataAxesGrid.XTitleFontFile = ''
	highAspectRatioCellsvtkDisplay.DataAxesGrid.YTitleFontFile = ''
	highAspectRatioCellsvtkDisplay.DataAxesGrid.ZTitleFontFile = ''
	highAspectRatioCellsvtkDisplay.DataAxesGrid.XLabelFontFile = ''
	highAspectRatioCellsvtkDisplay.DataAxesGrid.YLabelFontFile = ''
	highAspectRatioCellsvtkDisplay.DataAxesGrid.ZLabelFontFile = ''
	highAspectRatioCellsvtkDisplay.PolarAxes.PolarAxisTitleFontFile = ''
	highAspectRatioCellsvtkDisplay.PolarAxes.PolarAxisLabelFontFile = ''
	highAspectRatioCellsvtkDisplay.PolarAxes.LastRadialAxisTextFontFile = ''
	highAspectRatioCellsvtkDisplay.PolarAxes.SecondaryRadialAxesTextFontFile = ''
	renderView1.Update()
	highAspectRatioCellsvtkDisplay.DiffuseColor = [0.3333333333333333, 0.6666666666666666, 0.4980392156862745]
	highAspectRatioCellsvtkDisplay.PointSize = 13.0
	highAspectRatioCellsvtkDisplay.SetRepresentationType('Points')
	highAspectRatioCellsvtkDisplay.AmbientColor = [1.0, 1.0, 0.0]
	

if os.path.exists(dirnonOrthoFaces):	
	bad=True
	nonOrthoFacesvtk = LegacyVTKReader(FileNames=[dirnonOrthoFaces])
	nonOrthoFacesvtkDisplay = Show(nonOrthoFacesvtk, renderView1)
	nonOrthoFacesvtkDisplay.Representation = 'Surface'
	nonOrthoFacesvtkDisplay.ColorArrayName = [None, '']
	nonOrthoFacesvtkDisplay.OSPRayScaleFunction = 'PiecewiseFunction'
	nonOrthoFacesvtkDisplay.SelectOrientationVectors = 'None'
	nonOrthoFacesvtkDisplay.ScaleFactor = 0.008748781681060792
	nonOrthoFacesvtkDisplay.SelectScaleArray = 'None'
	nonOrthoFacesvtkDisplay.GlyphType = 'Arrow'
	nonOrthoFacesvtkDisplay.GlyphTableIndexArray = 'None'
	nonOrthoFacesvtkDisplay.GaussianRadius = 0.00043743908405303956
	nonOrthoFacesvtkDisplay.SetScaleArray = [None, '']
	nonOrthoFacesvtkDisplay.ScaleTransferFunction = 'PiecewiseFunction'
	nonOrthoFacesvtkDisplay.OpacityArray = [None, '']
	nonOrthoFacesvtkDisplay.OpacityTransferFunction = 'PiecewiseFunction'
	nonOrthoFacesvtkDisplay.DataAxesGrid = 'GridAxesRepresentation'
	nonOrthoFacesvtkDisplay.SelectionCellLabelFontFile = ''
	nonOrthoFacesvtkDisplay.SelectionPointLabelFontFile = ''
	nonOrthoFacesvtkDisplay.PolarAxes = 'PolarAxesRepresentation'
	nonOrthoFacesvtkDisplay.DataAxesGrid.XTitleFontFile = ''
	nonOrthoFacesvtkDisplay.DataAxesGrid.YTitleFontFile = ''
	nonOrthoFacesvtkDisplay.DataAxesGrid.ZTitleFontFile = ''
	nonOrthoFacesvtkDisplay.DataAxesGrid.XLabelFontFile = ''
	nonOrthoFacesvtkDisplay.DataAxesGrid.YLabelFontFile = ''
	nonOrthoFacesvtkDisplay.DataAxesGrid.ZLabelFontFile = ''
	nonOrthoFacesvtkDisplay.PolarAxes.PolarAxisTitleFontFile = ''
	nonOrthoFacesvtkDisplay.PolarAxes.PolarAxisLabelFontFile = ''
	nonOrthoFacesvtkDisplay.PolarAxes.LastRadialAxisTextFontFile = ''
	nonOrthoFacesvtkDisplay.PolarAxes.SecondaryRadialAxesTextFontFile = ''
	renderView1.Update()
	nonOrthoFacesvtkDisplay.PointSize = 13.0
	nonOrthoFacesvtkDisplay.SetRepresentationType('Points')
	nonOrthoFacesvtkDisplay.AmbientColor = [0.6666666666666666, 0.6666666666666666, 0.0]
	nonOrthoFacesvtkDisplay.AmbientColor = [1.0, 1.0, 0.0]

if os.path.exists(dirskewFaces):	
	poor=True
	skewFacesvtk = LegacyVTKReader(FileNames=[dirskewFaces])
	skewFacesvtkDisplay = Show(skewFacesvtk, renderView1)
	skewFacesvtkDisplay.Representation = 'Surface'
	skewFacesvtkDisplay.ColorArrayName = [None, '']
	skewFacesvtkDisplay.OSPRayScaleFunction = 'PiecewiseFunction'
	skewFacesvtkDisplay.SelectOrientationVectors = 'None'
	skewFacesvtkDisplay.ScaleFactor = 0.5194070219993592
	skewFacesvtkDisplay.SelectScaleArray = 'None'
	skewFacesvtkDisplay.GlyphType = 'Arrow'
	skewFacesvtkDisplay.GlyphTableIndexArray = 'None'
	skewFacesvtkDisplay.GaussianRadius = 0.025970351099967957
	skewFacesvtkDisplay.SetScaleArray = [None, '']
	skewFacesvtkDisplay.ScaleTransferFunction = 'PiecewiseFunction'
	skewFacesvtkDisplay.OpacityArray = [None, '']
	skewFacesvtkDisplay.OpacityTransferFunction = 'PiecewiseFunction'
	skewFacesvtkDisplay.DataAxesGrid = 'GridAxesRepresentation'
	skewFacesvtkDisplay.SelectionCellLabelFontFile = ''
	skewFacesvtkDisplay.SelectionPointLabelFontFile = ''
	skewFacesvtkDisplay.PolarAxes = 'PolarAxesRepresentation'
	skewFacesvtkDisplay.DataAxesGrid.XTitleFontFile = ''
	skewFacesvtkDisplay.DataAxesGrid.YTitleFontFile = ''
	skewFacesvtkDisplay.DataAxesGrid.ZTitleFontFile = ''
	skewFacesvtkDisplay.DataAxesGrid.XLabelFontFile = ''
	skewFacesvtkDisplay.DataAxesGrid.YLabelFontFile = ''
	skewFacesvtkDisplay.DataAxesGrid.ZLabelFontFile = ''
	skewFacesvtkDisplay.PolarAxes.PolarAxisTitleFontFile = ''
	skewFacesvtkDisplay.PolarAxes.PolarAxisLabelFontFile = ''
	skewFacesvtkDisplay.PolarAxes.LastRadialAxisTextFontFile = ''
	skewFacesvtkDisplay.PolarAxes.SecondaryRadialAxesTextFontFile = ''
	renderView1.Update()
	skewFacesvtkDisplay.PointSize = 10.0
	skewFacesvtkDisplay.SetRepresentationType('Points')
	skewFacesvtkDisplay.AmbientColor = [0.0, 1.0, 0.0]


if os.path.exists(dirwrongOrientedFaces):	
	awful=True
	wrongOrientedFacesvtk = LegacyVTKReader(FileNames=[dirwrongOrientedFaces])
	wrongOrientedFacesvtkDisplay = Show(wrongOrientedFacesvtk, renderView1)
	wrongOrientedFacesvtkDisplay.Representation = 'Surface'
	wrongOrientedFacesvtkDisplay.ColorArrayName = [None, '']
	wrongOrientedFacesvtkDisplay.OSPRayScaleFunction = 'PiecewiseFunction'
	wrongOrientedFacesvtkDisplay.SelectOrientationVectors = 'None'
	wrongOrientedFacesvtkDisplay.ScaleFactor = 0.008330923318862916
	wrongOrientedFacesvtkDisplay.SelectScaleArray = 'None'
	wrongOrientedFacesvtkDisplay.GlyphType = 'Arrow'
	wrongOrientedFacesvtkDisplay.GlyphTableIndexArray = 'None'
	wrongOrientedFacesvtkDisplay.GaussianRadius = 0.0004165461659431458
	wrongOrientedFacesvtkDisplay.SetScaleArray = [None, '']
	wrongOrientedFacesvtkDisplay.ScaleTransferFunction = 'PiecewiseFunction'
	wrongOrientedFacesvtkDisplay.OpacityArray = [None, '']
	wrongOrientedFacesvtkDisplay.OpacityTransferFunction = 'PiecewiseFunction'
	wrongOrientedFacesvtkDisplay.DataAxesGrid = 'GridAxesRepresentation'
	wrongOrientedFacesvtkDisplay.SelectionCellLabelFontFile = ''
	wrongOrientedFacesvtkDisplay.SelectionPointLabelFontFile = ''
	wrongOrientedFacesvtkDisplay.PolarAxes = 'PolarAxesRepresentation'
	wrongOrientedFacesvtkDisplay.DataAxesGrid.XTitleFontFile = ''
	wrongOrientedFacesvtkDisplay.DataAxesGrid.YTitleFontFile = ''
	wrongOrientedFacesvtkDisplay.DataAxesGrid.ZTitleFontFile = ''
	wrongOrientedFacesvtkDisplay.DataAxesGrid.XLabelFontFile = ''
	wrongOrientedFacesvtkDisplay.DataAxesGrid.YLabelFontFile = ''
	wrongOrientedFacesvtkDisplay.DataAxesGrid.ZLabelFontFile = ''
	wrongOrientedFacesvtkDisplay.PolarAxes.PolarAxisTitleFontFile = ''
	wrongOrientedFacesvtkDisplay.PolarAxes.PolarAxisLabelFontFile = ''
	wrongOrientedFacesvtkDisplay.PolarAxes.LastRadialAxisTextFontFile = ''
	wrongOrientedFacesvtkDisplay.PolarAxes.SecondaryRadialAxesTextFontFile = ''
	renderView1.Update()
	wrongOrientedFacesvtkDisplay.PointSize = 16.0
	wrongOrientedFacesvtkDisplay.SetRepresentationType('Points')
	wrongOrientedFacesvtkDisplay.AmbientColor = [1.0, 0.6666666666666666, 0.0]
	
if os.path.exists(dirzeroVolumeCells):	
	awful=True
	zeroVolumeCellsvtk = LegacyVTKReader(FileNames=[dirzeroVolumeCells])
	zeroVolumeCellsvtkDisplay = Show(zeroVolumeCellsvtk, renderView1)
	zeroVolumeCellsvtkDisplay.Representation = 'Surface'
	zeroVolumeCellsvtkDisplay.ColorArrayName = [None, '']
	zeroVolumeCellsvtkDisplay.OSPRayScaleFunction = 'PiecewiseFunction'
	zeroVolumeCellsvtkDisplay.SelectOrientationVectors = 'None'
	zeroVolumeCellsvtkDisplay.ScaleFactor = 0.008330923318862916
	zeroVolumeCellsvtkDisplay.SelectScaleArray = 'None'
	zeroVolumeCellsvtkDisplay.GlyphType = 'Arrow'
	zeroVolumeCellsvtkDisplay.GlyphTableIndexArray = 'None'
	zeroVolumeCellsvtkDisplay.GaussianRadius = 0.0004165461659431458
	zeroVolumeCellsvtkDisplay.SetScaleArray = [None, '']
	zeroVolumeCellsvtkDisplay.ScaleTransferFunction = 'PiecewiseFunction'
	zeroVolumeCellsvtkDisplay.OpacityArray = [None, '']
	zeroVolumeCellsvtkDisplay.OpacityTransferFunction = 'PiecewiseFunction'
	zeroVolumeCellsvtkDisplay.DataAxesGrid = 'GridAxesRepresentation'
	zeroVolumeCellsvtkDisplay.SelectionCellLabelFontFile = ''
	zeroVolumeCellsvtkDisplay.SelectionPointLabelFontFile = ''
	zeroVolumeCellsvtkDisplay.PolarAxes = 'PolarAxesRepresentation'
	zeroVolumeCellsvtkDisplay.DataAxesGrid.XTitleFontFile = ''
	zeroVolumeCellsvtkDisplay.DataAxesGrid.YTitleFontFile = ''
	zeroVolumeCellsvtkDisplay.DataAxesGrid.ZTitleFontFile = ''
	zeroVolumeCellsvtkDisplay.DataAxesGrid.XLabelFontFile = ''
	zeroVolumeCellsvtkDisplay.DataAxesGrid.YLabelFontFile = ''
	zeroVolumeCellsvtkDisplay.DataAxesGrid.ZLabelFontFile = ''
	zeroVolumeCellsvtkDisplay.PolarAxes.PolarAxisTitleFontFile = ''
	zeroVolumeCellsvtkDisplay.PolarAxes.PolarAxisLabelFontFile = ''
	zeroVolumeCellsvtkDisplay.PolarAxes.LastRadialAxisTextFontFile = ''
	zeroVolumeCellsvtkDisplay.PolarAxes.SecondaryRadialAxesTextFontFile = ''
	renderView1.Update()
	zeroVolumeCellsvtkDisplay.PointSize = 16.0
	zeroVolumeCellsvtkDisplay.SetRepresentationType('Points')
	zeroVolumeCellsvtkDisplay.AmbientColor = [1.0, 0.0, 0.0]







# create a new 'Text'
text1 = Text()
text1.Text = 'Awful cells'
text1Display = Show(text1, renderView1)
text1Display.FontFile = ''
renderView1.Update()
text1Display.FontSize = 14
text1Display.Color = [1.0, 0.0, 0.0]
text1Display.WindowLocation = 'Any Location'
text1Display.Position = [0.77, 0.71]
text2 = Text()
text2.Text = 'Bad cells'
text2Display = Show(text2, renderView1)
text2Display.FontFile = ''
renderView1.Update()
text2Display.FontSize = 14
text2Display.Color = [1.0, 1.0, 0.0]
text2Display.WindowLocation = 'Any Location'
text2Display.Position = [0.77, 0.78]
text3 = Text()
text3.Text = 'Poor cells'
text3Display = Show(text3, renderView1)
text3Display.FontFile = ''
renderView1.Update()
text3Display.FontSize = 14
text3Display.Color = [0.0, 1.0, 0.0]
text3Display.WindowLocation = 'Any Location'
text3Display.Position = [0.77, 0.85]


text4 = Text()
text4.Text = 'Mesh quality warnings :'
text4Display = Show(text4, renderView1)
text4Display.FontFile = ''
renderView1.Update()
text4Display.FontSize = 16
text4Display.WindowLocation = 'Any Location'
text4Display.Position = [0.57, 0.92]





# maxU
if os.path.exists(dirmaxU):	
	with open(dirmaxU, 'r') as f:
		Umax = f.read().splitlines()
	text5 = Text()
	text5.Text = 'Maximum Velocity Point ('+str(Umax[0])+' m/s)'
	text5Display = Show(text5, renderView1)
	text5Display.FontFile = ''
	renderView1.Update()
	text5Display.Color = [1.0, 0.0, 1.0]
	text5Display.FontSize = 14
	text5Display.WindowLocation = 'Any Location'
	text5Display.Position = [0.2, 0.012]
	
	sphere1 = Sphere()
	sphere1.Radius = maxSize * 0.2
	sphere1.ThetaResolution = 16
	sphere1.Center = [float(Umax[1]), float(Umax[2]), float(Umax[3])]
	sphere1Display = Show(sphere1, renderView1, 'GeometryRepresentation')
	sphere1Display.Representation = 'Surface'
	sphere1Display.ColorArrayName = [None, '']
	sphere1Display.OSPRayScaleArray = 'Normals'
	sphere1Display.OSPRayScaleFunction = 'PiecewiseFunction'
	sphere1Display.SelectOrientationVectors = 'None'
	sphere1Display.ScaleFactor = 0.010292799770832063
	sphere1Display.SelectScaleArray = 'None'
	sphere1Display.GlyphType = 'Arrow'
	sphere1Display.GlyphTableIndexArray = 'None'
	sphere1Display.GaussianRadius = 0.0005146399885416031
	sphere1Display.SetScaleArray = ['POINTS', 'Normals']
	sphere1Display.ScaleTransferFunction = 'PiecewiseFunction'
	sphere1Display.OpacityArray = ['POINTS', 'Normals']
	sphere1Display.OpacityTransferFunction = 'PiecewiseFunction'
	sphere1Display.DataAxesGrid = 'GridAxesRepresentation'
	sphere1Display.PolarAxes = 'PolarAxesRepresentation'
	sphere1Display.ScaleTransferFunction.Points = [-0.9749279022216797, 0.0, 0.5, 0.0, 0.9749279022216797, 1.0, 0.5, 0.0]
	sphere1Display.OpacityTransferFunction.Points = [-0.9749279022216797, 0.0, 0.5, 0.0, 0.9749279022216797, 1.0, 0.5, 0.0]
	sphere1Display.AmbientColor = [1.0, 0.0, 1.0]
	sphere1Display.DiffuseColor = [1.0, 0.0, 1.0]
	renderView1.Update()



#exporting views
renderView1.CameraFocalPoint = [XfocalPoint, YfocalPoint, ZfocalPoint]
renderView1.CameraParallelScale = 1.0

renderView1.CameraPosition = [XfocalPoint, YfocalPoint, camDist1]
renderView1.CameraViewUp = [0, 1, 0]
SaveScreenshot('./IMG/ErrorViewZpos.jpg', renderView1, ImageResolution=[1920, 1080], Quality=90)
renderView1.CameraPosition = [XfocalPoint, YfocalPoint, -camDist1]
renderView1.CameraViewUp = [0, 1, 0]
SaveScreenshot('./IMG/ErrorViewZneg.jpg', renderView1, ImageResolution=[1920, 1080], Quality=90)
renderView1.CameraPosition = [XfocalPoint, camDist1, ZfocalPoint]
renderView1.CameraViewUp = [0, 0, 1]
SaveScreenshot('./IMG/ErrorViewYpos.jpg', renderView1, ImageResolution=[1920, 1080], Quality=90)
renderView1.CameraPosition = [XfocalPoint, -camDist1, ZfocalPoint]
renderView1.CameraViewUp = [0, 0, 1]
SaveScreenshot('./IMG/ErrorViewYneg.jpg', renderView1, ImageResolution=[1920, 1080], Quality=90)
renderView1.CameraPosition = [camDist1, YfocalPoint, ZfocalPoint]
renderView1.CameraViewUp = [0, 0, 1]
SaveScreenshot('./IMG/ErrorViewXpos.jpg', renderView1, ImageResolution=[1920, 1080], Quality=90)
renderView1.CameraPosition = [-camDist1, YfocalPoint, ZfocalPoint]
renderView1.CameraViewUp = [0, 0, 1]
SaveScreenshot('./IMG/ErrorViewXneg.jpg', renderView1, ImageResolution=[1920, 1080], Quality=90)
renderView1.CameraPosition = [-camDist2, camDist2, -camDist2]
renderView1.CameraViewUp = [0, 0, 1]
SaveScreenshot('./IMG/ErrorViewTQ1.jpg', renderView1, ImageResolution=[1920, 1080], Quality=90)
renderView1.CameraPosition = [-camDist2, camDist2, camDist2]
renderView1.CameraViewUp = [0, 0, 1]
SaveScreenshot('./IMG/ErrorViewTQ2.jpg', renderView1, ImageResolution=[1920, 1080], Quality=90)
renderView1.CameraPosition = [camDist2, camDist2, camDist2]
renderView1.CameraViewUp = [0, 0, 1]
SaveScreenshot('./IMG/ErrorViewTQ3.jpg', renderView1, ImageResolution=[1920, 1080], Quality=90)
renderView1.CameraPosition = [camDist2, camDist2, -camDist2]
renderView1.CameraViewUp = [0, 0, 1]
SaveScreenshot('./IMG/ErrorViewTQ4.jpg', renderView1, ImageResolution=[1920, 1080], Quality=90)

#export vtp for max velocity
SetActiveSource(sphere1)
SaveData('./VTKexports/aircraft_maximum-velocity-point.vtp', proxy=sphere1)
SetActiveSource(meshedAircraftSurfaceobj)
SaveData('./VTKexports/aircraft_meshed-surfaces.vtp', proxy=meshedAircraftSurfaceobj)



